<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model 
{

    protected $table = 'subscriptions';
    public $timestamps = true;

    public function pet()
    {
        return $this->belongsTo('Pet', 'pet_id');
    }

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function package()
    {
        return $this->belongsTo('App\Models\Package', 'package_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function payments()
    {
        return $this->hasMany('Payment', 'subscription_id');
    }

}